from peft import LoraConfig, get_peft_model

lora_configs = {}

gpt2_configs = LoraConfig(
    r=8,
    lora_alpha=16,
    lora_dropout=0.05,
    bias="none",
    task_type="CAUSAL_LM",
    fan_in_fan_out = True # Must be True for GPT 2 models
    )

# for zephyr model only
target_modules = ["q_proj", "k_proj", "v_proj", "o_proj", "gate_proj", "up_proj", "down_proj"]
zephyr_config = LoraConfig(
    r=8,
    lora_alpha=16,
    lora_dropout=0.05,
    bias="none",
    task_type="CAUSAL_LM",
    target_modules = target_modules
)

llama_config = LoraConfig(
    r=8,
    lora_alpha=32,
    lora_dropout=0.05,
    bias="none",
    task_type="CAUSAL_LM",
    target_modules="all-linear",
    #inference_mode = False,
)


lora_configs["gpt2"] =  gpt2_configs
lora_configs["zephyr"] =  zephyr_config
lora_configs["llama"] =  llama_config
